/*
 * Decompiled with CFR 0.152.
 */
package tcintegrations.items.modifiers.armor;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import tcintegrations.TCIntegrations;
import tcintegrations.common.capabilities.CapabilityRegistry;
import tcintegrations.items.TCIntegrationsModifiers;
import tcintegrations.network.BotaniaSetData;
import tcintegrations.network.NetworkHandler;
import tcintegrations.util.BotaniaClientHelper;
import tcintegrations.util.BotaniaHelper;
import vazkii.botania.api.mana.ManaItemHandler;

public class GreatFairyModifier
extends Modifier {
    private static final int MANA_PER_DAMAGE = 70;

    public int getManaPerDamage(Player player) {
        return BotaniaHelper.getManaPerDamageBonus(player, 70);
    }

    @NotNull
    public Component getDisplayName(int level) {
        return this.applyStyle((MutableComponent)new TranslatableComponent(this.getTranslationKey()));
    }

    public MutableComponent applyStyle(MutableComponent component) {
        if (BotaniaClientHelper.hasGreatFairyArmorSet()) {
            return component.m_130938_(style -> style.m_131148_(this.getTextColor()));
        }
        return component.m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.STRIKETHROUGH);
    }

    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
                boolean hasSet = this.hasArmorSetItem(sp, EquipmentSlot.HEAD) && this.hasArmorSetItem(sp, EquipmentSlot.CHEST) && this.hasArmorSetItem(sp, EquipmentSlot.LEGS) && this.hasArmorSetItem(sp, EquipmentSlot.FEET);
                data.setGreatFairy(hasSet);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new BotaniaSetData(data.hasTerrestrial(), hasSet));
            });
        }
    }

    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        Player player;
        Player player2 = player = context.getEntity() instanceof Player ? (Player)context.getEntity() : null;
        if (player != null && !player.f_19853_.f_46443_) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.getCapability(CapabilityRegistry.BOTANIA_SET_CAPABILITY).ifPresent(data -> {
                data.setGreatFairy(false);
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> sp), (Object)new BotaniaSetData(data.hasTerrestrial(), false));
            });
        }
    }

    public void onInventoryTick(IToolStackView tool, int level, Level world, LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        if (!world.f_46443_ && holder.f_19797_ % 20 == 0 && holder instanceof Player) {
            Player player = (Player)holder;
            if (tool.getDamage() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaPerDamage(player) * 2, true)) {
                tool.setDamage(tool.getDamage() - 1);
            }
        }
    }

    public void onAttacked(IToolStackView tool, int level, EquipmentContext context, EquipmentSlot slotType, DamageSource source, float amount, boolean isDirectDamage) {
        LivingEntity livingEntity = context.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.f_19853_.f_46443_ && (livingEntity = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity attacker = livingEntity;
                if (isDirectDamage && BotaniaHelper.hasGreatFairyArmorSet(player)) {
                    Float chance;
                    ServerPlayer sp = (ServerPlayer)player;
                    switch (slotType) {
                        case HEAD: {
                            Float f = Float.valueOf(0.11f);
                            break;
                        }
                        case CHEST: {
                            Float f = Float.valueOf(0.17f);
                            break;
                        }
                        case LEGS: {
                            Float f = Float.valueOf(0.15f);
                            break;
                        }
                        default: {
                            Float f = chance = Float.valueOf(0.09f);
                        }
                    }
                    if (TCIntegrations.RANDOM.nextFloat() <= chance.floatValue()) {
                        BotaniaHelper.spawnPixie(sp, ItemStack.f_41583_, attacker);
                    }
                }
            }
        }
    }

    public boolean hasArmorSetItem(ServerPlayer sp, EquipmentSlot slot) {
        ItemStack stack = sp.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        ToolStack armor = ToolStack.from((ItemStack)stack);
        if (armor.isBroken()) {
            return false;
        }
        return armor.getUpgrades().getLevel(TCIntegrationsModifiers.GREAT_FAIRY_MODIFIER.getId()) > 0;
    }
}

